function [abs rel] = updateNetFluorescence(rawfluorescence, fluorescenceBG)
% Helper function to update net fluorescence measures, after I updated the
% net fluorescence change calciulation on September 12, 2012.
%   - rel: relative fluorescence change, with the initial state set to 0%.
%   - abs: absolute fluorescence change, with the initial state set to the
%          value above background.  useful when analyzing mutants and
%          comparing baseline levels of fluorescence with wild-type.

abs = zeros(size(rawfluorescence));
rel = zeros(size(rawfluorescence));

for i=1:size(rawfluorescence, 2)
    abs(:,i) = rawfluorescence(:,i) - fluorescenceBG;
    rel(:,i) = abs(:,i) / (rawfluorescence(1,i) - fluorescenceBG(1)) - 1;
end
    
end